<?php

function setupAvalibleCamera()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $array = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($array);
   if (!is_array($array)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   foreach ($array as $object) {
      if (isContainNull($object)) {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
      if (isset($object["index"])) {
         $index = $object["index"];

         if (isset($object["name"])) {
            $name = $object["name"];
            ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
            ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);
         }
         if (isset($object["ip"])) {
            $ip = $object["ip"];
            ParamSetString($sock, "video.input.[" . $index . "].ip", $ip);
         }
         if (isset($object["portOnvif"])) {
            $portOnvif = $object["portOnvif"];
            ParamSetInt($sock, "video.input.[" . $index . "].portOnvif", $portOnvif);
            ParamSetInt($sock, "video.input.[" . $index . "].port2", $portOnvif);
         }
         if (isset($object["username"])) {
            $username = $object["username"];
            ParamSetString($sock, "video.input.[" . $index . "].username", $username);
         }
         if (isset($object["pass"])) {
            $pass = $object["pass"];
            ParamSetString($sock, "video.input.[" . $index . "].cam_password", $pass);
         }

         sleep(1);
         ParamSetInt($sock, "video.input.[" . $index . "].mediatype", 82);
         sleep(3);
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 1);
      }
   }
}
function setupAvalibleCameras()
{
   $sock = Login();
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }
   $object = json_decode(file_get_contents("php://input"), true);
   ParamSetString($sock, "server.onvifcamlogin", ConvertUTF2Native($object["login"]));
   ParamSetString($sock, "server.onvifcampassword", ConvertUTF2Native($object["password"]));
   sleep(3);
   $array = $object["array"];
   foreach ($array as $object) {
      ParamSetInt($sock, "video.input.[" . $object["index"] . "].mediatype", 82);
   }
   sleep(3);
   $status = OnvifMaster($sock);
   sleep(3);
   foreach ($array as $object) {
      ParamSetInt($sock, "video.input.[" . $object["index"] . "].mediatype", 80);
   }
   socket_close($sock);
   return $status;
}
